//Experiment No.12
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//This Source file is Written by Dr. T. Subbulaskhmi, Professor, 
//School of Computing Science and Engineering, VIT University Chennai 
//using the NARVAL examples of Scilab for Network Topology Creation  
//The Operating System used for writing the code found in this file is Windows 8
//SCILAB version 5.5.2 and NARVAL toolbox version 3.1//This Program is Written by Dr. T. Subbulaskhmi, Professor, School of Computing Science and Engineering, VIT University Chennai using the NARVAL examples of Scilab for Network Topology Creation  

clear;
clc;

NetworkSize=7;//network size
NeworkSquareArea=1000;//network square area side
LocalityRadius=1000;//locality radius
[TopologyGraph]=NL_T_LocalityConnex(NetworkSize,NeworkSquareArea,LocalityRadius);//generation of a random topology in respect with the Locality method. 
for i=1:1:NetworkSize
    disp(i,"node number :");
    [dist,pred]=NL_R_Dijkstra(TopologyGraph,i);//application of NL_R_Dijkstra
    j=dist;
    for x = j
    disp(x);
    plot(j);
    xlabel("Nodenumber", "fontsize", 2)
    ylabel("Distance");
    end
end
for i=1:1:NetworkSize
    [TopologyGraph]=NL_T_LocalityConnex(NetworkSize,NeworkSquareArea,LocalityRadius);//generation of a random topology in respect with the Locality method. 
    [dist,pred]=NL_R_Dijkstra(TopologyGraph,i);//application of NL_R_Dijkstra
    TopologyGraph.node_diam(i)=40;//node diameter
    TopologyGraph.node_border(i)=10;//node border
    TopologyGraph.node_color(i)=5;//node color
   [GraphVisualize]=NL_G_ShowGraphN(TopologyGraph,i);//graph visualization 
xtitle("LocalityConnexMethod","NodeNumber","Distance");
end
